$(function(){
	$(document).click(function(){
		$('#box-character, #btn-box-character').removeClass('active');
		$('.section-head .actions .dropdown').removeClass('show');
	});
	$('.tooltip').tooltipster({
		delay: 0,
		theme: 'tooltipster-punk',
		animation: 'grow',
	});
	$('.category li span').tooltipster({
		delay: 0,
		theme: 'muhn',
		animation: 'fade',
		side: 'right',
		distance: -12
	});


	$('.owl-carousel').owlCarousel({
	    loop:true,
	    margin:0,
	    nav:true,
	    items: 1,
	    autoplay: true,
	    smartSpeed: 500,
	    navText: ['←','→']
	});
	$('.section-head .actions div').click(function(e){
		e.stopPropagation();
		$(this).find('.dropdown').toggleClass('show');
	});

	$('.no-login #btn-head-links').click(function(){
		$('.header .links').toggleClass('show');
	});
	$('.logged #btn-head-links').click(function(){
		$('.dark-bar').toggleClass('show');
	});

	$('#collapse-userinfo').click(function(){
		$('.box-userinfo').toggleClass('show');
	});
	$('#btn-box-character').click(function(e){
		e.stopPropagation();
		$('#box-character, #btn-box-character').toggleClass('active');
	});
	$('#category li').click(function(){
		var menu = $(this).attr('menu');
		$('#category-tabs > ul, #category li').removeClass('active');
		$('#category-tabs > [menu='+menu+']').addClass('active');
		$(this).addClass('active');
	});
	$(window).scroll(function(){
		if($(window).scrollTop() >= 238){
			$('.menu').addClass('fixed');
		}
		else{
			$('.menu').removeClass('fixed');	
		}
	});

	$('.form-login input').focus(function(){
		$('.form-login .btn-submit').addClass('active');
	}).on('active',function(){
		$('.form-login .btn-submit').addClass('active');
	}).blur(function(){
		$('.form-login .btn-submit').removeClass('active');
	});

	$('body').on('mouseover','.warehouse_move .tdr-img', function(){
		$(this).parent().find('.tdr-item-info').addClass('show');
	});
	$('body').on('mouseout','.warehouse_move', function(){
		$(this).parent().find('.tdr-item-info').removeClass('show');
	});
	$('body').on('click', '.tstcls', function(){
		var parent = $(this).parent();
		parent.removeClass('show');
		setTimeout(function(){
			parent.remove();
		}, 500);
	});
	$('body').on('click', '[data-controls] .tab', function(){
		var tab = $(this).parent().data('controls');
		var idx = $(this).index();
		$('[data-controls='+tab+'] > .tab, [data-tabs='+tab+'] > .tab').removeClass('active');
		$('[data-controls='+tab+'] > .tab:eq('+idx+'), [data-tabs='+tab+'] > .tab:eq('+idx+')').addClass('active');
	});
});